package org.simantics.scl.compiler.internal.interpreted;


public class IIf implements IExpression {
    private final IExpression condition;
    private final IExpression thenBranch;
    private final IExpression elseBranch;
    
    public IIf(IExpression condition, IExpression thenBranch,
            IExpression elseBranch) {
        this.condition = condition;
        this.thenBranch = thenBranch;
        this.elseBranch = elseBranch;
    }

    @Override
    public Object execute(Object[] variableBindings) {
        if((Boolean)condition.execute(variableBindings))
            return thenBranch.execute(variableBindings);
        else
            return elseBranch.execute(variableBindings);
    }
    
    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("(if ");
        b.append(condition);
        b.append(" then ");
        b.append(thenBranch);
        b.append(" else ");
        b.append(elseBranch);
        b.append(')');
        return b.toString();
    }
}
