package org.simantics.scl.compiler.internal.elaboration.constraints2;

import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class ConstraintHandle {
    public final TPred constraint;
    public final long demandLocation;
    private ConstraintResolution resolution;
    
    public ConstraintHandle(TPred constraint, long demandLocation) {
        this.constraint = constraint;
        this.demandLocation = demandLocation;
    }
    
    public ConstraintResolution getResolution() {
        return resolution;
    }

    public void setResolution(ConstraintResolution newResolution) {
        if(resolution == null || newResolution.priority > resolution.priority)
            resolution = newResolution;
    }

    public String toString(TypeUnparsingContext tuc) {
        return constraint.toString(tuc) +  (resolution != null ? " <= " + resolution.toString(tuc) : "");
    }
}
