package org.simantics.scl.compiler.internal.deriving;

import org.simantics.scl.compiler.internal.parsing.types.TApplyAst;
import org.simantics.scl.compiler.internal.parsing.types.TTupleAst;
import org.simantics.scl.compiler.internal.parsing.types.TVarAst;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;

class DerivingUtils {
    
    static TVarAst getHeadType(TypeAst typeAst) {
        while(true) {
            if(typeAst instanceof TApplyAst)
                typeAst = ((TApplyAst)typeAst).function;
            else if(typeAst instanceof TVarAst)
                return (TVarAst)typeAst;
            else if(typeAst instanceof TTupleAst) {
                TTupleAst tuple = (TTupleAst)typeAst;
                if(tuple.components.length == 1)
                    typeAst = tuple.components[0];
                else
                    return null;
            }
            else
                return null;
        }
    }
    
}
