package org.simantics.scl.compiler.internal.codegen.utils;

import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.constants.SCLConstant;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAModule;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSASimplificationContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSASimplificationContext.class);

    SSAModule module;
    Environment environment;
    boolean modified = false;
    public static int modiId = 0;
    int phase;
    
    public SSASimplificationContext(SSAModule module, Environment environment, int phase) {
        this.module = module;
        this.environment = environment;
        this.phase = phase;
    }

    public void markModified(String description) {
        if(SCLCompilerConfiguration.PRINT_OPTIMIZATION_TRANSFORMATIONS)
            LOGGER.info("(" + modiId + ") DID " + description);
        modified = true;
        if(SCLCompilerConfiguration.VALIDATE_AFTER_OPTIMIZATIONS)
            module.validate();
        ++ modiId;
    }

    public boolean didModify() {
        return modified;
    }
    
    public Environment getEnvironment() {
        return environment;
    }
    
    public int getPhase() {
        return phase;
    }

    static int tempNameCount = 0;
    
    public void addConstant(SCLConstant constant) {
        module.put(constant.getName(), constant);        
    }
    
    public SCLConstant removeConstant(Name name) {
        return module.remove(name);
    }
    
    public void printConstant(Name name) {
        LOGGER.info("--- " + name + " ---------------------------");
        LOGGER.info("{}", module.get(name));
    }

    public void validate() {
        module.validate();
    }
}
