package org.simantics.scl.compiler.internal.codegen.utils;

import org.simantics.scl.compiler.types.TCon;
import org.simantics.scl.compiler.types.TPred;


public class JavaNamingPolicy {

    private final String moduleName;
    private final String moduleClassName;
    int closureCount = 0;

    public JavaNamingPolicy(String moduleName) {
        this.moduleName = moduleName;
        this.moduleClassName = "scl/" + moduleNameToClassName(moduleName);
    }
    
    private static boolean isAllowableClassNameChar(char c) {
        return (c >= 'a' && c <= 'z')
                || (c >= 'A' && c <= 'Z')
                || (c >= '0' && c <= '9')
                || c == '$'
                ;
    }
    
    public static String moduleNameToClassName(String moduleName) {
        StringBuilder b = new StringBuilder(moduleName.length());
        int length = moduleName.length();
        for(int i=0;i<length;++i) {
            char c = moduleName.charAt(i);
            if(c == '/' || isAllowableClassNameChar(c))
                b.append(c);
            else
                b.append('_').append((int)c).append('_');
        }
        //System.out.println("m2c " + moduleName + " -> " + b.toString());
        return b.toString().replace("..", "._.").replace("//", "/_/");
    }
    
    public static String classNameToModuleName(String className) {
        className = className.replace("/_/", "//").replace("._.", "..");
        StringBuilder b = new StringBuilder(className.length());
        int length = className.length();
        for(int i=0;i<length;++i) {
            char c = className.charAt(i);
            if(c == '.')
                b.append('/');
            else if(c == '_') {
                StringBuilder nb = new StringBuilder(4);
                while(true) {
                    c = className.charAt(++i);
                    if(Character.isDigit(c))
                        nb.append(c);
                    else
                        break;
                }
                b.append((char)Integer.parseInt(nb.toString()));
            }
            else 
                b.append(c);
        }
        //System.out.println("c2m " + className + " -> " + b.toString());
        return b.toString();
    }
    
    public String getModuleClassName() {
        return moduleClassName;
    }
    
    public String getMethodName(String name) {
        return NameMangling.mangle(name);
    }

    public String getFreshClosureClassNameSuffix() {
        return "$" + (++closureCount);
    }
    
    public String getFreshClosureClassName() {
        return moduleClassName + "$" + (++closureCount);
    }

    public String getDataTypeClassName(String name) {
        return moduleClassName + "$" + name; 
    }
    
    public String getConstructorClassName(String name) {
        return moduleClassName + "$" + name + "Constructor";
    }
    
    public String getTypeClassInterfaceName(TCon name) {
        return moduleClassName + "$" + name.name + "Class"; 
    }

    public String getTypeClassInstanceClassName(String name) {
        return moduleClassName + "$" + name + "Instance";
    }

    public String getInstanceClassName(TPred instance) {
        return moduleClassName + "$" + instance.toName();
    }

    public String getModuleName() {
        return moduleName;
    }    
}
