package org.simantics.scl.compiler.internal.codegen.utils;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.continuations.ContRef;
import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.map.hash.THashMap;

public class CopyContext {

    THashMap<Val, Val> valMap = new THashMap<Val, Val>();
    THashMap<Cont, Cont> contMap = new THashMap<Cont, Cont>();
    THashMap<TVar, TVar> tvarMap = new THashMap<TVar, TVar>(); 
    
    public void put(Val src, Val tgt) {
        Val ret = valMap.put(src, tgt);
        if(SCLCompilerConfiguration.DEBUG) {
            if(ret != null)
                throw new InternalCompilerError();
        }
    }

    public void put(Cont src, Cont tgt) {
        Cont ret = contMap.put(src, tgt);
        if(SCLCompilerConfiguration.DEBUG) {
            if(ret != null)
                throw new InternalCompilerError();
        }
    }
    
    public TVar[] copyParameters(TVar[] vars) {
        TVar[] result = new TVar[vars.length];
        for(int i=0;i<vars.length;++i) {
            TVar var = vars[i];
            TVar newVar = Types.var(var.getKind());
            result[i] = newVar;
            tvarMap.put(var, newVar);
        }
        return result;
    }

    public BoundVar[] copy(BoundVar[] src) {
        BoundVar[] tgt = new BoundVar[src.length];
        for(int i=0;i<src.length;++i)
            tgt[i] = copy(src[i]);
        return tgt;
    }
    
    public ValRef[] copy(ValRef[] src) {
        ValRef[] tgt = new ValRef[src.length];
        for(int i=0;i<src.length;++i)
            tgt[i] = copy(src[i]);
        return tgt;
    }
    
    public ValRef copy(ValRef src) {
        return copy(src.getBinding())
                .createOccurrence(Types.replace(src.getTypeParameters(), tvarMap));
    }

    @SuppressWarnings("unchecked")
    public <T extends Val> T copy(T src) {
        Val tgt = valMap.get(src);
        if(tgt != null)
            return (T)tgt;
        tgt = src.copy(tvarMap);
        valMap.put(src, tgt);
        return (T)tgt;
    }
    
    public ContRef[] copy(ContRef[] src) {
        ContRef[] tgt = new ContRef[src.length];
        for(int i=0;i<src.length;++i)
            tgt[i] = copy(src[i]);
        return tgt;
    }
    
    public ContRef copy(ContRef src) {
        return copy(src.getBinding()).createOccurrence();
    }

    @SuppressWarnings("unchecked")
    public <T extends Cont> T copy(T src) {
        Cont tgt = contMap.get(src);
        if(tgt != null)
            return (T)tgt;
        tgt = src.copy(this);
        contMap.put(src, tgt);
        return (T)tgt;
    }

    public Type copyType(Type type) {
        return type.replace(tvarMap); 
    }

}
