package org.simantics.scl.compiler.internal.codegen.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.runtime.tuple.Tuple0;

public class Constants {
    
    // Parameters
    public static final int MAX_FUNCTION_PARAMETER_COUNT = 8;
    public static final int MAX_TUPLE_LENGTH = 32;
    public static final int MAX_LIST_LITERAL_LENGTH = 32;
    
    public static final String ROOT_PACKAGE = "org/simantics/scl/runtime";
    public static final String FUNCTION_PACKAGE = ROOT_PACKAGE + "/function";
    public static final String TUPLE_PACKAGE = ROOT_PACKAGE + "/tuple";

    // Constants
    public static final TypeDesc LIST = TypeDesc.forClass(List.class);
    public static final TypeDesc COLLECTION = TypeDesc.forClass(Collection.class);
    public static final TypeDesc OBJECT_ARRAY = TypeDesc.forClass(Object[].class);
    public static final TypeDesc CLASS = TypeDesc.forClass(Class.class);
    
    public static final TypeDesc FUNCTION = TypeDesc.forClass(FUNCTION_PACKAGE + ".Function");
    public static final TypeDesc[] FUNCTION_IMPL = new TypeDesc[MAX_FUNCTION_PARAMETER_COUNT+1];
    public static final TypeDesc FUNCTION_N_IMPL;
    public static final TypeDesc[][] OBJECTS = 
            new TypeDesc[MAX_FUNCTION_PARAMETER_COUNT+1][];
    
    public static final String MathBuiltinFunctions_class = 
            ROOT_PACKAGE + ".MathBuiltinFunctions";
    public static final TypeDesc[] EMPTY_TYPEDESC_ARRAY = new TypeDesc[0];
    
    public static final TypeDesc TUPLE0 = TypeDesc.forClass(Tuple0.class);
    public static final TypeDesc[] TUPLE = new TypeDesc[MAX_TUPLE_LENGTH+1];
    
    static {
        for(int count=0;count<=MAX_FUNCTION_PARAMETER_COUNT;++count) {
            OBJECTS[count] = new TypeDesc[count];
            Arrays.fill(OBJECTS[count], TypeDesc.OBJECT);
        }
        for(int i=1;i<=MAX_FUNCTION_PARAMETER_COUNT;++i) {
            FUNCTION_IMPL[i] = TypeDesc.forClass(FUNCTION_PACKAGE + "/FunctionImpl" + i);
        }
        FUNCTION_N_IMPL = TypeDesc.forClass(FUNCTION_PACKAGE + ".FunctionImplN");
        TUPLE[0] = TypeDesc.VOID;
        for(int i=2;i<=MAX_TUPLE_LENGTH;++i) 
            TUPLE[i] = TypeDesc.forClass(TUPLE_PACKAGE + ".Tuple" + i);
    }
    
}
