package org.simantics.scl.compiler.internal.codegen.types;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.constants.generic.ClassRef;

@SuppressWarnings("hiding")
public interface JavaReferenceValidator<Class,Method,Field,Constructor> {

    /**
     * Tries to find the given class or returns null if the class
     * does not exist.
     */
    Class findClass(TypeDesc name);
    
    boolean isInterface(Class clazz);
    
    boolean isPublic(Class clazz);
    
    /**
     * Finds all methods that are compatible with type
     * <pre>types[0] -> types[1] -> ... -> types[types.length-1]</pre> 
     */
    Method[] findCompatibleMethods(Class clazz, boolean isStatic, String name, 
            TypeDesc[] parameterTypes, TypeDesc returnType);
    TypeDesc getReturnType(Method method);    
    TypeDesc[] getParameterTypes(Method method);

    Constructor[] findCompatibleConstructors(Class clazz, TypeDesc[] types);
    TypeDesc[] getConstructorParameterTypes(Constructor constructor);
    
    Field findField(Class clazz, String name);
    boolean isStaticField(Field field);
    TypeDesc getFieldType(Field field);
    boolean isAssignableFrom(TypeDesc to, TypeDesc from);

    Method[] chooseBest(Method[] methods);
    
    /**
     * Returns a class ref object to the class or null if the
     * class is not found.
     */
    ClassRef getClassRef(String className);

    ClassLoader getClassLoader();
}
