package org.simantics.scl.compiler.internal.codegen.references;

import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.util.Typed;

public interface IVal extends Typed {

    ValRef createOccurrence();
    ValRef createOccurrence(Type ... parameters);
    
    IVal createSpecialization(Type ... parameters);

    void push(MethodBuilder mb);
    Type apply(MethodBuilder mb, Type[] typeParameters, Val ... parameters);
    
    Object realizeValue(TransientClassBuilder classBuilder);
    void setLabel(String label);
    
}
