package org.simantics.scl.compiler.internal.codegen.continuations;

import java.io.Serializable;

import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAExit;


public final class ContRef implements Serializable { 
    public static final ValRef[] EMPTY_ARRAY = new ValRef[0];

    Cont binding;
    ContRef prev; // FreeVars with the same binding form a linked list
    ContRef next;     
    SSAExit parent;
    
    ContRef(Cont binding) {
        this.binding = binding;
        
        ContRef head = binding.occurrence;
        binding.occurrence = this;
        this.next = head;
        if(head != null)
            head.prev = this;
    }    
    
    public void remove() {
        if(prev == null)
            binding.occurrence = next;
        else
            prev.next = next;
        if(next != null)
            next.prev = prev;
    }

    public Cont getBinding() {
        return binding;
    }
    
    public ContRef getNext() {
        return next;
    }

    public void setParent(SSAExit parent) {
        this.parent = parent;
    }

    public Cont addParametersInFront(Val[] newParameters, Val[] oldParameters, Cont proxy) {
        return parent.addParametersInFrontOf(this, newParameters, oldParameters, proxy);
    }
    
    public SSAExit getParent() {
        return parent;
    }
}
