package org.simantics.scl.compiler.internal.codegen.chr;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.elaboration.expressions.block.IncludeStatement;

public interface CHRCodeGenerationConstants {

    public static final TypeDesc FACT_ID_TYPE = TypeDesc.INT;
    
    public static final String CHRHashIndex_name = "org/simantics/scl/runtime/chr/CHRHashIndex";
    public static final TypeDesc CHRHashIndex = TypeDesc.forClass(CHRHashIndex_name);
    
    public static final String CHRFact_name = "org/simantics/scl/runtime/chr/CHRFact";
    public static final TypeDesc CHRFact = TypeDesc.forClass(CHRFact_name);
    
    public static final String CHRPriority_name = "org/simantics/scl/runtime/chr/CHRPriority";
    
    public static final String CHRPriorityFactContainer_name = "org/simantics/scl/runtime/chr/CHRPriorityFactContainer";
    public static final TypeDesc CHRPriorityFactContainer = TypeDesc.forClass(CHRPriorityFactContainer_name);
    
    public static final String CHRContext_name = "org/simantics/scl/runtime/chr/CHRContext";
    public static final TypeDesc CHRContext = TypeDesc.forClass(CHRContext_name);
    
    public static final String CHRRuntimeRuleset_name = "org/simantics/scl/runtime/chr/CHRRuntimeRuleset";
    public static final TypeDesc CHRRuntimeRuleset = TypeDesc.forClass(CHRRuntimeRuleset_name);

    public static String priorityName(int priority) {
        return "l" + priority;
    }

    public static String fieldName(int id) {
        return "c" + id;
    }

    public static String parameterName(int i) {
        return "p" + i;
    }

    public static String includedName(IncludeStatement include) {
        return "included" + include.name.text; 
    }

    public static String nextContainerName(String name) {
        return name + "$nextContainer";
    }
}
