package org.simantics.scl.compiler.errors;

import java.io.PrintStream;

@SuppressWarnings("rawtypes")
public class Failure implements Failable {
    public final CompilationError[] errors;

    public Failure(CompilationError[] errors) {
        this.errors = errors;
    }
    
    public Failure(String description) {
        this.errors = new CompilationError[] { new CompilationError(description) };
    }
    
    public Failure(Exception e) {
        this.errors = new CompilationError[] { new CompilationError(e) };
    }

    public void printTo(PrintStream out) {
        for(CompilationError error : errors)
            out.println(error.description);
    }

    public String toString(String source) {
        return CompilationErrorFormatter.toString(source, errors);
    }
    
    @Override
    public String toString() {
        return CompilationErrorFormatter.toString(errors);
    }
    
    @Override
    public Object getResult() {
        throw new IllegalStateException("Module compilation failed.");
    }

    @Override
    public boolean didSucceed() {
        return false;
    }

    @Override
    public String getDescription() {
        StringBuilder b = new StringBuilder();
        b.append("Module compilation failed:");
        for(CompilationError error : errors)
            b.append("\n    ").append(error.description);
        return b.toString();
    }
}
