package org.simantics.scl.compiler.environment.specification;

import java.util.ArrayList;
import java.util.List;

import org.simantics.scl.compiler.module.ImportDeclaration;
import org.simantics.scl.runtime.tuple.Tuple2;

public class EnvironmentSpecification {
    public final ArrayList<ImportDeclaration> imports = new ArrayList<ImportDeclaration>();
    
    public void importModule(String moduleName, String localName) {
        imports.add(new ImportDeclaration(moduleName, localName));
    }
    
    public static EnvironmentSpecification of(String ... strings) {
        if(strings.length % 2 != 0)
            throw new IllegalArgumentException("Expected even number of parameters.");
        EnvironmentSpecification spec = new EnvironmentSpecification();
        for(int i=0;i<strings.length;i+=2)
            spec.importModule(strings[i], strings[i+1]);
        return spec;
    }
    
    public static EnvironmentSpecification fromList(List<Tuple2> imports) {
        EnvironmentSpecification spec = new EnvironmentSpecification();
        for(Tuple2 tuple : imports)
            spec.importModule((String)tuple.c0, (String)tuple.c1);
        return spec;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((imports == null) ? 0 : imports.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        EnvironmentSpecification other = (EnvironmentSpecification) obj;
        if (imports == null) {
            if (other.imports != null)
                return false;
        } else if (!imports.equals(other.imports))
            return false;
        return true;
    }
}
