package org.simantics.scl.compiler.environment.filter;

import gnu.trove.set.hash.THashSet;

public class PositiveNamespaceFilter implements NamespaceFilter {
    THashSet<String> includedValues;

    public PositiveNamespaceFilter(THashSet<String> includedValues) {
        this.includedValues = includedValues;
    }

    @Override
    public boolean isValueIncluded(String name) {
        return includedValues.contains(name);
    }
    
    @Override
    public String toString() {
        return "Include" + includedValues.toString();
    }

    @Override
    public boolean isSubsetOf(NamespaceFilter filter) {
        if(filter == AcceptAllNamespaceFilter.INSTANCE)
            return true;
        for(String name : includedValues)
            if(!filter.isValueIncluded(name))
                return false;
        return true;
    }
}
