package org.simantics.scl.compiler.environment;

import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.util.ProcedureType;

import gnu.trove.procedure.TObjectProcedure;

/**
 * Provides local variable names for expressions
 * that do not need to defined in any module.
 * 
 * @author Hannu Niemist&ouml;
 */
public interface LocalEnvironment {
    /**
     * Resolves the variable name to an expression evaluating it.
     * Returns null if the local environment does not provide the variable.
     */
    Expression resolve(Environment environment, String localName);
    
    /**
     * Lists all names of variables provided by this environment.
     * The method is used only for error reporting, so its efficiently
     * or completion is not absolutely necessary.
     */
    void forNames(TObjectProcedure<String> proc);
    
    /**
     * Modifies the expression before type checking.
     */
    Expression preDecorateExpression(Expression expression);
    
    /**
     * Modifies the expression after type checking.
     */
    Expression postDecorateExpression(Expression expression);
    
    /**
     * Modifies expected type and effect before type checking.
     */
    ProcedureType decorateExpectedType(Type expectedType, Type expectedEffect);
}
