package org.simantics.scl.compiler.environment;

import java.util.Arrays;
import java.util.Collection;

/**
 * An exception for a name conflict between imported SCL modules. This exception is thrown by the
 * methods of the {@link Namespace} class.
 */
public class AmbiguousNameException extends Exception {
    private static final long serialVersionUID = 1448746846203589730L;
    
    public final String[] conflictingModules;
    public final String name;
    
    /**
     * Construct the exception with a collection of modules and a name.
     * @param conflictingModules  a collection of modules that are in name conflict
     * @param name  the conflicting name
     */
    public AmbiguousNameException(Collection<String> conflictingModules, String name) {
        this.conflictingModules = conflictingModules.toArray(new String[conflictingModules.size()]);
        Arrays.sort(this.conflictingModules);
        this.name = name;
    }
    
    @Override
    public synchronized Throwable fillInStackTrace() {
        return this;
    }
    
    @Override
    public String getMessage() {
        StringBuilder b = new StringBuilder();
        b.append("Ambiguous reference to " + name + ". It can be found from modules ");
        for(int i=0;i<conflictingModules.length;++i) {
            if(i > 0) {
                if(i == conflictingModules.length-1)
                    b.append(" and ");
                else
                    b.append(", ");
            }
            b.append(conflictingModules[i]);
        }
        b.append('.');
        return b.toString();
    }
}
