package org.simantics.scl.compiler.elaboration.rules;

import gnu.trove.map.hash.THashMap;

public enum SectionName {
    when(SectionRole.MATCH, SectionRole.MATCH),
    where(SectionRole.ENFORCE, SectionRole.ENFORCE),
    from(SectionRole.MATCH, SectionRole.ENFORCE),
    to(SectionRole.ENFORCE, SectionRole.MATCH),
    
    fromCondition(SectionRole.MATCH, SectionRole.IGNORE),
    toCondition(SectionRole.IGNORE, SectionRole.MATCH),
    fromEnforce(SectionRole.ENFORCE, SectionRole.IGNORE),
    toEnforce(SectionRole.IGNORE, SectionRole.ENFORCE),
    fromDefault(SectionRole.ENFORCE_FIRST_TIME, SectionRole.IGNORE),
    toDefault(SectionRole.IGNORE, SectionRole.ENFORCE_FIRST_TIME);
    
    public final SectionRole forwardRole;
    public final SectionRole backwardRole;
    
    private SectionName(SectionRole forwardRole, SectionRole backwardRole) {
        this.forwardRole = forwardRole;
        this.backwardRole = backwardRole;
    }

    private static final THashMap<String,SectionName> SECTION_NAME_MAP = 
            new THashMap<String,SectionName>();
    
    static {
        for(SectionName sectionName : values())
            SECTION_NAME_MAP.put(sectionName.name(), sectionName);
    }
    
    public static SectionName getSectionName(String name) {
        return SECTION_NAME_MAP.get(name);
    }
}
