package org.simantics.scl.compiler.elaboration.relations;

import org.simantics.scl.compiler.elaboration.chr.plan.PlanContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.EnforcingContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public interface SCLRelation {
    
    public static final int F = 0;
    public static final int B = 1;
    
    public static final int FF = 0;
    public static final int BF = 1;
    public static final int FB = 2;
    public static final int BB = 3;
    
    public static final int FFF = 0;
    public static final int BFF = 1;
    public static final int FBF = 2;
    public static final int BBF = 3;
    public static final int FFB = 4;
    public static final int BFB = 5;
    public static final int FBB = 6;
    public static final int BBB = 7;
    
    TVar[] getTypeVariables();
    Type[] getParameterTypes();
    default TPred[] getTypeConstraints() {
        return TPred.EMPTY_ARRAY;
    }
    int getPhase();

    double getSelectivity(int boundVariables);
    int getRequiredVariablesMask();
    void generate(long location,
            QueryCompilationContext context,
            Type[] typeParameters,
            Variable[] parameters, int boundVariables);
    Expression generateEnforce(long location, EnforcingContext context,
            Type[] typeParameters,
            Variable[] parameters);
    default String[] getFieldNames() {
        return null;
    }
    
    void generateIterate(
            PlanContext context,
            CodeWriter w,
            long location,
            int boundMask,
            Variable[] variables,
            Expression[] expressions,
            Expression[] typeConstraintEvidenceParameters);
    void generateEnforce(
            PlanContext context,
            CodeWriter w,
            long location,
            Expression[] parameters,
            Expression[] typeConstraintEvidenceParameters);
    Type getEnforceEffect();
    Type getQueryEffect();
}
