package org.simantics.scl.compiler.elaboration.query.compilation;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.expressions.Variable;

import gnu.trove.impl.Constants;
import gnu.trove.map.hash.TObjectIntHashMap;

public class ConstraintCollectionContext {
    QueryCompilationContext context;
    ArrayList<Variable> variables = new ArrayList<Variable>();
    TObjectIntHashMap<Variable> variableMap = new TObjectIntHashMap<Variable>(
            Constants.DEFAULT_CAPACITY, Constants.DEFAULT_LOAD_FACTOR, -1);
    ArrayList<QueryConstraint> constraints = new ArrayList<QueryConstraint>(); 
    
    public ConstraintCollectionContext(QueryCompilationContext context) {
        this.context = context;
    }

    public int addVariable(Variable variable) {
        int id = variables.size();
        variables.add(variable);
        variableMap.put(variable, id);
        return id;
    }
    
    public TObjectIntHashMap<Variable> getVariableMap() {
        return variableMap;
    }
    
    public void addConstraint(QueryConstraint constraint) {
        constraints.add(constraint);
    }

    public QueryConstraint[] getConstraints() {
        return constraints.toArray(new QueryConstraint[constraints.size()]);
    }
    
    public QueryCompilationContext getQueryCompilationContext() {
        return context;
    }
    
    public Variable getVariable(int id) {
        return variables.get(id);
    }
}
