package org.simantics.scl.compiler.elaboration.query;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;
import org.simantics.scl.compiler.elaboration.query.compilation.UnsolvableQueryException;
import org.simantics.scl.compiler.elaboration.rules.MappingRelation;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.types.Type;

public class QMapping extends Query {
    public final MappingRelation mappingRelation;
    public final Expression[] parameters;
    
    public QMapping(MappingRelation mappingRelation, Expression[] parameters) {
        this.mappingRelation = mappingRelation;
        this.parameters = parameters;
    }

    @Override
    public void checkType(TypingContext context) {
        // Check parameter types
        Type[] parameterTypes = mappingRelation.parameterTypes;
        if(parameterTypes.length != parameters.length)
            context.getErrorLog().log(location, "Relation is applied with wrong number of parameters.");
        else
            for(int i=0;i<parameters.length;++i)
                parameters[i] = parameters[i].checkType(context, parameterTypes[i]);
    }

    @Override
    public void collectConstraints(ConstraintCollectionContext context)
            throws UnsolvableQueryException {
        throw new InternalCompilerError();
    }

    @Override
    public Query replace(ReplaceContext context) {
        return new QMapping(mappingRelation,
                Expression.replace(context, parameters));
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            for(Expression parameter : parameters)
                parameter.setLocationDeep(loc);
        }
    }

    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }
}
