package org.simantics.scl.compiler.elaboration.query;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.expressions.QueryTransformer;
import org.simantics.scl.compiler.elaboration.query.compilation.ConstraintCollectionContext;


public class QAlternative extends QAbstractCombiner {

    public QAlternative(Query ... queries) {
        super(queries);
    }

    @Override
    public void collectConstraints(final ConstraintCollectionContext context) {
        throw new UnsupportedOperationException();
    }
    
    @Override
    public Query replace(ReplaceContext context) {
        Query[] newQueries = new Query[queries.length];
        for(int i=0;i<queries.length;++i)
            newQueries[i] = queries[i].replace(context);
        return new QAlternative(newQueries);
    }
 
    @Override
    public void accept(QueryVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Query accept(QueryTransformer transformer) {
        return transformer.transform(this);
    }

}
