package org.simantics.scl.compiler.elaboration.modules;

import java.util.Map;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.elaboration.errors.ElabNode;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;

public class TypeClassInstance extends ElabNode {
    public final TypeClass typeClass;
    public final TPred[] context;    
    public final TPred instance;  
    public final Map<String, MethodImplementation> methodImplementations;
    public final Constant generator;
    public final TVar[] generatorParameters;
    public final String javaName;
    public SCLValue[] superExpressions;
        
    public TypeClassInstance(long loc, TypeClass typeClass,
            Constant generator, 
            TVar[] generatorParameters, TPred[] context, TPred instance,
            Map<String, MethodImplementation> methodImplementations,
            String javaName) {
        this.location = loc;
        this.typeClass = typeClass;
        this.generator = generator;
        this.generatorParameters = generatorParameters;                
        this.context = context;
        this.instance = instance;        
        this.methodImplementations = methodImplementations;
        this.javaName = javaName;
    }
    
    /*
    public void toString(final StringBuilder b) {
        final TypeUnparsingContext tuc = new TypeUnparsingContext();
        b.append("instance (");
        for(int i=0;i<context.length;++i) {
            if(i>0)
                b.append(", ");
            context[i].toString(tuc);
            b.append(context[i]);
        }
        b.append(") => ");
        b.append(instance.toString(tuc));
        b.append(" where\n");
        methodImplementations.forEachEntry(new TObjectObjectProcedure<String, Name>() {            
            @Override
            public boolean execute(String name, Name functionName) {
                b.append("    ");
                b.append(name);
                b.append(" = ");
                b.append(functionName);
                b.append('\n');
                return true;
            }
        });
    }
    */
}
