package org.simantics.scl.compiler.elaboration.java;

import org.cojen.classfile.TypeDesc;
import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class SetMVector extends FunctionValue {
    private static final TVar A = Types.var(Kinds.STAR);
    public static final SetMVector INSTANCE = new SetMVector();    
    
    private SetMVector() {
        super(new TVar[] {A}, Types.PROC, Types.UNIT, Types.mvector(A), Types.INTEGER, A);
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        Val vector = parameters[0];
        Val index = parameters[1];
        Val value = parameters[2];
        
        vector.push(mb);
        index.push(mb);
        
        try {
            Type elementType = Types.canonical(
                    Types.matchApply(Types.MVECTOR, vector.getType()));
            if(elementType instanceof TVar) {
                mb.push(value, elementType);
                mb.invokeStatic("java/lang/reflect/Array", "set", TypeDesc.VOID, 
                        new TypeDesc[] {TypeDesc.OBJECT, TypeDesc.INT, TypeDesc.OBJECT});
                return Types.UNIT;
            }
            else {
                value.push(mb);
                TypeDesc desc = mb.getJavaTypeTranslator().toTypeDesc(elementType);
                mb.storeToArray(desc);
                return Types.UNIT;
            }
        } catch (MatchException e) {
            throw new InternalCompilerError(e);
        }
    }   

}
