package org.simantics.scl.compiler.elaboration.java;

import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Expressions;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.query.compilation.EnforcingContext;
import org.simantics.scl.compiler.elaboration.query.compilation.QueryCompilationContext;
import org.simantics.scl.compiler.elaboration.relations.AbstractRelation;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class ExecuteRelation extends AbstractRelation {
    int phase;
    
    public ExecuteRelation(int phase) {
        this.phase = phase;
    }
    
    private static TVar A = Types.var(Kinds.STAR);
    private static TVar E = Types.var(Kinds.EFFECT);
    private static TVar[] TYPE_VARIABLES = new TVar[] {A, E};
    
    @Override
    public TVar[] getTypeVariables() {
        return TYPE_VARIABLES;
    }
    
    private static final Type[] PARAMETER_TYPES = new Type[] {Types.functionE(Types.PUNIT, E, A)};

    @Override
    public Type[] getParameterTypes() {
        return PARAMETER_TYPES;
    }

    @Override
    public int getPhase() {
        return phase;
    }
    
    @Override
    public double getSelectivity(int boundVariables) {
        return Double.POSITIVE_INFINITY;
    }
    
    @Override
    public int getRequiredVariablesMask() {
        return B;
    }

    @Override
    public void generate(long location,
            QueryCompilationContext context,
            Type[] typeParameters, Variable[] parameters, int boundVariables) {
        throw new IllegalArgumentException();
    }

    @Override
    public Expression generateEnforce(long location, EnforcingContext context,
            Type[] typeParameters,
            Variable[] parameters) {
        return new EApply(
                Expressions.var(parameters[0]),
                Expressions.punit());
    }
    
    @Override
    public String toString() {
        return "Execute";
    }

    @Override
    public Type getEnforceEffect() {
        return Types.NO_EFFECTS;
    }

    @Override
    public Type getQueryEffect() {
        return Types.NO_EFFECTS;
    }
}
