package org.simantics.scl.compiler.elaboration.expressions.visitors;

import org.simantics.scl.compiler.elaboration.expressions.EAsPattern;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Variable;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

public class CollectVarsVisitor extends StandardExpressionVisitor {
    private final TObjectIntHashMap<Variable> allVars;
    private final TIntHashSet vars;
    
    public CollectVarsVisitor(TObjectIntHashMap<Variable> allVars, TIntHashSet vars) {
        this.allVars = allVars;
        this.vars = vars;
    }

    @Override
    public void visit(EVariable expression) {
        if(expression.variable != null) {
            int id = allVars.get(expression.variable);
            if(id >= 0)
                vars.add(id);
        }
    }
    
    @Override
    public void visit(EAsPattern expression) {
        int id = allVars.get(expression.var);
        if(id >= 0)
            vars.add(id);
        expression.pattern.accept(this);
    }
}
