package org.simantics.scl.compiler.elaboration.expressions.visitors;

import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.elaboration.query.QAtom;
import org.simantics.scl.compiler.elaboration.relations.CompositeRelation;
import org.simantics.scl.compiler.elaboration.relations.SCLRelation;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;

public class CollectRefsVisitor extends StandardExpressionVisitor {
    private final TObjectIntHashMap<Object> allRefs;
    private final TIntHashSet refs;
    
    public CollectRefsVisitor(TObjectIntHashMap<Object> allRefs, TIntHashSet refs) {
        this.allRefs = allRefs;
        this.refs = refs;
    }
    
    @Override
    public void visit(ETransformation expression) {
        {
            int ref = allRefs.get(ETransformation.TRANSFORMATION_RULES_TYPECHECKED);
            if(ref >= 0)
                refs.add(ref);
        }
        super.visit(expression);
    }
    
    @Override
    public void visit(EConstant expression) {
        int id = allRefs.get(expression.value);
        if(id >= 0)
            refs.add(id);
    }
    
    @Override
    public void visit(QAtom query) {
        collectRelationRefs(query.relation);
        super.visit(query);
    }
    
    private void collectRelationRefs(SCLRelation relation) {
        if(relation instanceof CompositeRelation) {
            for(SCLRelation subrelation : ((CompositeRelation) relation).getSubrelations())
                collectRelationRefs(subrelation);
        }
        else {
            int id = allRefs.get(relation);
            if(id >= 0)
                refs.add(id);
        }
    }
}
