package org.simantics.scl.compiler.elaboration.expressions.visitors;

import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.CHRRule;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.ECHRSelect;
import org.simantics.scl.compiler.elaboration.expressions.EFieldAccess;
import org.simantics.scl.compiler.elaboration.expressions.ELambda;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLambda;
import org.simantics.scl.compiler.elaboration.expressions.ETransformation;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.set.hash.THashSet;

public class CollectEffectsVisitor extends StandardExpressionVisitor {
    public final THashSet<Type> effects = new THashSet<Type>();
    
    @Override
    public void visit(EApply expression) {
        effects.add(expression.effect);
        super.visit(expression);
    }
    
    @Override
    public void visit(CHRRule rule) {
        for(CHRLiteral literal : rule.head.literals) {
            super.visit(literal);
            literal.relation.collectQueryEffects(effects);
        }
        for(CHRLiteral literal : rule.body.literals) {
            super.visit(literal);
            literal.relation.collectEnforceEffects(effects);
        }
    }
    
    @Override
    public void visit(ECHRSelect expression) {
        for(CHRLiteral literal : expression.query.literals) {
            super.visit(literal);
            literal.relation.collectQueryEffects(effects);
        }
        expression.expression.accept(this);
    }
    
    @Override
    public void visit(EFieldAccess expression) {
        // FIXME
        effects.add(Types.READ_GRAPH);
        super.visit(expression);
    }
    
    @Override
    public void visit(ETransformation expression) {
        // FIXME
        effects.add(Types.PROC);
        super.visit(expression);
    }
    
    @Override
    public void visit(ELambda expression) {
    }
    
    @Override
    public void visit(ESimpleLambda expression) {
    }
    
    public Type getCombinedEffect() {
        return Types.union(effects.toArray(new Type[effects.size()]));
    }
}
