package org.simantics.scl.compiler.elaboration.expressions.list;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.errors.Locations;

public class ListSeq extends ListQualifier {
    public ListQualifier a;
    public ListQualifier b;
    
    public ListSeq(ListQualifier a, ListQualifier b) {
        this.a = a;
        this.b = b;
    }

    @Override
    public void checkType(TypingContext context) {
        a.checkType(context);
        b.checkType(context);  
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        CompiledQualifier cA = a.compile(context);
        CompiledQualifier cB = b.compile(context);      
        
        Variable x = new Variable("xTemp", cA.pattern.getType());
        Variable y = new Variable("yTemp", cB.pattern.getType());
        
        Expression value = context.concatMap( 
                context.lambda(context.var(x), context.mapList(
                        context.lambda(context.var(y), context.tuple(context.var(x), context.var(y))),
                        context.match(context.var(x), cA.pattern, cB.value))), 
                        cA.value);
        /*try {
            value.validateType(context.getEnvironment());
        } catch (TypeValidationException e) {
            e.printStackTrace();
        }*/
        return new CompiledQualifier(value, context.tuple(cA.pattern, cB.pattern));
    }

    @Override
    public void resolve(TranslationContext context) {
        a.resolve(context);
        b.resolve(context);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            a.setLocationDeep(loc);
            b.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public ListQualifier accept(ListQualifierTransformer transformer) {
        return transformer.transform(this);
    }
}
