package org.simantics.scl.compiler.elaboration.expressions.list;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.types.Types;

public class ListGuard extends ListQualifier {
    public Expression condition;

    public ListGuard(Expression condition) {
        this.condition = condition;
    }

    @Override
    public void checkType(TypingContext context) {
        condition = condition.checkType(context, Types.BOOLEAN);
    }

    @Override
    public CompiledQualifier compile(SimplificationContext context) {
        return new CompiledQualifier(
                context.guardList(condition.copy()), 
                context.tuple());
    }

    @Override
    public void resolve(TranslationContext context) {
        condition = condition.resolve(context);
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            condition.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ListQualifierVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public ListQualifier accept(ListQualifierTransformer transformer) {
        return transformer.transform(this);
    }
}
