package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;

public class BindStatement extends Statement {
    public Expression pattern;
    public Expression value;
    
    public BindStatement(Expression pattern, Expression value) {
        this.pattern = pattern;
        this.value = value;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, BlockType blockType, Expression in) {
        return new EBind(location, blockType, pattern, value, in);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            pattern.setLocationDeep(loc);
            value.setLocationDeep(loc);
        }
    }

    @Override
    public void resolvePattern(TranslationContext context) {
        pattern = pattern.resolveAsPattern(context);
    }
    
    @Override
    public boolean mayBeRecursive() {
        return false;
    }
    
    @Override
    public Statement replace(ReplaceContext context) {
        return new BindStatement(pattern.replaceInPattern(context), value.replace(context));
    }

    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StatementGroup getStatementGroup() {
        return null;
    }
}
