package org.simantics.scl.compiler.elaboration.expressions.accessor;

import org.simantics.scl.compiler.constants.StringConstant;
import org.simantics.scl.compiler.elaboration.expressions.ELiteral;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;

public class IdAccessor extends FieldAccessor {
    public final String fieldName;

    public IdAccessor(char accessSeparator, String fieldName) {
        super(accessSeparator);
        this.fieldName = fieldName;
    }

    @Override
    public Expression asExpression() {
        return new ELiteral(new StringConstant(fieldName));
    }

    @Override
    public boolean isVariableId() {
        return fieldName.equals("variable");
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION)
            location = loc;
    }
    
    @Override
    public void accept(FieldAccessorVisitor visitor) {
        visitor.visit(this);
    }
}
