package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.exceptions.MatchException;

public class ETypeAnnotation extends SimplifiableExpression {
    public Expression value;
    Type type;
    TypeAst typeAst;
        
    public ETypeAnnotation(Expression value, TypeAst typeAst) {
        this.value = value;
        this.typeAst = typeAst;
    }

    public ETypeAnnotation(long loc, Expression value, Type type) {
        super(loc);
        this.value = value;
        this.type = type;
    }

    @Override
    protected void updateType() throws MatchException {
        setType(type);
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return value.simplify(context);
    }

    @Override
    public Expression resolve(TranslationContext context) {
        value = value.resolve(context);
        type = context.toType(typeAst);
        return this;
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        value = value.resolveAsPattern(context);
        type = context.toType(typeAst);
        return this;
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        return value.checkType(context, type);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            value.setLocationDeep(loc);
        }
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    public Expression getValue() {
        return value;
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

}
