package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.constants.StringInterpolation;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.errors.Locations;

public class EStringLiteral extends ASTExpression {
    
    public String[] strings;
    public Expression[] expressions;
   
    public EStringLiteral(String[] strings, Expression[] expressions) {
        this.strings = strings;
        this.expressions = expressions;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        Expression[] components = new Expression[expressions.length];
        SCLValue showForPrinting = context.getEnvironment().getValue(Names.Prelude_showForPrinting);
        for(int i=0;i<expressions.length;++i)
            components[i] = new EApply(new EConstant(showForPrinting), expressions[i]);
        EApply result = new EApply(new ELiteral(new StringInterpolation(strings)), components);
        result.setLocationDeep(location);
        return result.resolve(context);
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            for(Expression expression : expressions)
                expression.setLocationDeep(loc);
        }
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
    
    @Override
    public Expression resolveAsPattern(TranslationContext context) {
        for(int i=0;i<expressions.length;++i)
            expressions[i] = expressions[i].resolveAsPattern(context);
        if(expressions.length > 1) {
            context.getErrorLog().log(location, "String interpolation can be a pattern only if has one hole.");
            return new EError();
        }
        EApply result = new EApply(new ELiteral(new StringInterpolation(strings)), expressions);
        result.setLocationDeep(location);
        return result;
    }

    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
