package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.common.names.Names;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.errors.Locations;

public class ERange extends ASTExpression {
    public Expression from;
    public Expression to;
    
    public ERange(Expression from, Expression to) {
        this.from = from;
        this.to = to;
    }
    
    @Override
    public Expression resolve(TranslationContext context) {
        from = from.resolve(context);
        to = to.resolve(context);
        SCLValue rangeFunction = context.getEnvironment().getValue(Names.Prelude_range);
        return new EApply(location, new EConstant(rangeFunction), from, to);
    }    
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            from.setLocationDeep(loc);
            to.setLocationDeep(loc);
        }
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
}
