package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.elaboration.chr.ast.CHRAstQuery;
import org.simantics.scl.compiler.elaboration.chr.ast.CHRQueryTranslationMode;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;

public class EPreCHRSelect extends ASTExpression {
    CHRAstQuery query;
    Expression expression;
    
    public EPreCHRSelect(CHRAstQuery query, Expression expression) {
        this.query = query;
        this.expression = expression;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return new ECHRSelect(expression, query.translate(context, CHRQueryTranslationMode.QUERY_HEAD)).resolve(context);
    }
}
