package org.simantics.scl.compiler.elaboration.expressions;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.SimplificationContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.errors.Locations;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.exceptions.MatchException;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class EError extends Expression {

    public EError(long loc, Type type) {
        super(loc);
        setType(type);
    }
    
    public EError() {
    }
    
    public EError(long loc) {
        this(loc, Types.metaVar(Kinds.STAR));
    }

    @Override
    protected void updateType() throws MatchException {
        setType(Types.metaVar(Kinds.STAR));
    }

    @Override
    public IVal toVal(CompilationContext context, CodeWriter w) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Expression simplify(SimplificationContext context) {
        return this;
    }

    @Override
    public Expression resolve(TranslationContext context) {
        return this;
    }
    
    @Override
    public Expression inferType(TypingContext context) {
        return this;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION)
            location = loc;
    }
    
    @Override
    public void accept(ExpressionVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    public Expression replace(ReplaceContext context) {
        return this;
    }
    
    @Override
    public Expression accept(ExpressionTransformer transformer) {
        return transformer.transform(this);
    }

}
