package org.simantics.scl.compiler.elaboration.equation;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;

public class EqGuard extends Equation {
    public Expression guard;

    public EqGuard(Expression guard) {
        this.guard = guard;
    }
    
    public EqGuard(long location, Expression guard) {
        this(guard);
        this.location = location;
    }

    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            guard.setLocationDeep(loc);
        }
    }

    @Override
    public void checkType(TypingContext context) {
        guard = guard.checkIgnoredType(context);
    }

    @Override
    public void resolve(TranslationContext context) {
        guard = guard.resolve(context);
    }
    
    @Override
    public void accept(EquationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Equation replace(ReplaceContext context) {
        return new EqGuard(location, guard.replace(context));
    }
}
