package org.simantics.scl.compiler.elaboration.equation;

import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.contexts.TypingContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.errors.Locations;

public class EqBasic extends Equation {
    public Expression left;
    public Expression right;
    
    public EqBasic(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
    
    public EqBasic(long location, Expression left, Expression right) {
        this(left, right);
        this.location = location;
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            left.setLocationDeep(loc);
            right.setLocationDeep(loc);
        }
    }

    @Override
    public void checkType(TypingContext context) {
        left = left.inferType(context);
        right = right.checkType(context, left.getType());
    }

    @Override
    public void resolve(TranslationContext context) {
        left = left.resolve(context);
        right = right.resolve(context);
    }

    @Override
    public void accept(EquationVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Equation replace(ReplaceContext context) {
        return new EqBasic(location, left.replace(context), right.replace(context));
    }
}
