package org.simantics.scl.compiler.elaboration.contexts;

import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.elaboration.expressions.records.FieldAssignment;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.map.hash.THashMap;

public class ReplaceContext {
    public final THashMap<TVar, Type> EMPTY_VARIABLE_MAP = new THashMap<TVar, Type>(); 
    
    public THashMap<TVar, Type> tvarMap;
    public THashMap<Variable, Expression> varMap;
    public final TypingContext typingContext;
    public boolean inPattern;
    
    public ReplaceContext(THashMap<TVar, Type> tvarMap,
            THashMap<Variable, Expression> varMap,
            TypingContext typingContext) {
        this.tvarMap = tvarMap;
        this.varMap = varMap;
        this.typingContext = typingContext;
        this.inPattern = false;
    }
    
    public ReplaceContext(Variable[] from, Variable[] to) {
        this.tvarMap = EMPTY_VARIABLE_MAP;        
        this.typingContext = null;
        this.inPattern = false;
        varMap = new THashMap<Variable, Expression>(from.length);
        for(int i=0;i<from.length;++i)
            varMap.put(from[i], new EVariable(to[i]));
    }
    
    public ReplaceContext(TypingContext typingContext) {
        this(new THashMap<TVar, Type>(), new THashMap<Variable, Expression>(), typingContext);
    }
    
    public Expression[] replace(Expression[] expressions) {
        if(expressions == null)
            return null;
        Expression[] result = new Expression[expressions.length];
        for(int i=0;i<expressions.length;++i)
            result[i] = expressions[i].replace(this);
        return result;
    }

    public Type[] replace(Type[] types) {
        if(types == null)
            return null;
        return Types.replace(types, tvarMap);
    }

    public FieldAssignment[] replace(FieldAssignment[] fields) {
        if(fields == null)
            return null;
        FieldAssignment[] result = new FieldAssignment[fields.length];
        for(int i=0;i<fields.length;++i)
            result[i] = fields[i].replace(this);
        return result;
    }
}
