package org.simantics.scl.compiler.elaboration.contexts;

import org.simantics.scl.compiler.types.util.TypeUnparsingContext;

public class PrintingContext {
    StringBuilder b;
    public TypeUnparsingContext tuc;
    int indentation;
    
    public PrintingContext() {
        this.b = new StringBuilder();
        this.tuc = new TypeUnparsingContext();
        this.indentation = 0;
    }
    
    public void indent() {
        ++indentation;
    }
    
    public void dedent() {
        --indentation;
    }
    
    public void newLine() {
        b.append('\n');
        for(int i=0;i<indentation;++i)
            b.append("    ");
    }
    
    public void append(String str) {
        b.append(str);
    }
    
    @Override
    public String toString() {
        return b.toString();
    }

    public void append(char c) {
        b.append(c);
    }

    public void append(Object obj) {
        b.append(obj);
    }
}
