package org.simantics.scl.compiler.elaboration.chr.relations;

import org.simantics.scl.compiler.elaboration.chr.CHRRelation;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;

import gnu.trove.set.hash.THashSet;

public enum SpecialCHRRelation implements CHRRelation {    
    EQUALS(A, A), // only in head
    ASSIGN(A, A), // only in body
    MEMBER(A, Types.list(A)), // only in head
    CHECK(Types.BOOLEAN), // only in head
    EXECUTE(Types.UNIT); // only in body
    
    private final TVar[] typeVariables;
    private final Type[] parameterTypes;
    
    private SpecialCHRRelation(Type ... parameterTypes) {
        this.typeVariables = Types.freeVarsArray(parameterTypes);
        this.parameterTypes = parameterTypes;
    }

    @Override
    public TVar[] getTypeVariables() {
        return typeVariables;
    }
    
    @Override
    public Type[] getParameterTypes() {
        return parameterTypes;
    }
    
    public TPred[] getTypeConstraints() {
        return TPred.EMPTY_ARRAY;
    }

    @Override
    public void collectEnforceEffects(THashSet<Type> effects) {
    }

    @Override
    public void collectQueryEffects(THashSet<Type> effects) {
    }
}
