package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.IntegerConstant;
import org.simantics.scl.compiler.constants.singletons.NullCheck;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class PostCommitOp extends PlanOp {
    int priority;
    
    public PostCommitOp(long location, int priority) {
        super(location);
        this.priority = priority;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("POST_COMMIT " + priority);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        if(planContext.currentId != null) {
            w.apply(location, CHRRuleset.WRITE_CURRENT_ID, planContext.contextVar, planContext.currentId);
            planContext.currentId = null;
            w.apply(location, CHRRuleset.ACTIVATE, planContext.contextVar, new IntegerConstant(priority+planContext.ruleset.initialPriorityNumber));
        }
        for(PartnerFact activeFact : planContext.partnerFacts) {
            if(activeFact.killAfterMatch) {
                if(activeFact.nextFact == null)
                    w.jump(location, activeFact.finishCont);
                else {
                    CodeWriter iterateAlive = w.createBlock(activeFact.constraint.factType);
                    w.jump(location, iterateAlive.getContinuation(), w.apply(location, activeFact.nextFact, activeFact.factVar));
                    iterateUntilLiveFactFound(iterateAlive, activeFact);
                }
                break;
            }
            else if(activeFact.mayBeRemoved) {
                if(activeFact.nextFact == null) {
                    w.branchAwayUnless(location, activeFact.isAlive(location, w), activeFact.finishCont);
                }
                else {
                    CodeWriter failure = w.createBlock();
                    CodeWriter iterateAlive = w.createBlock(activeFact.constraint.factType);
                    w.branchAwayUnless(location, activeFact.isAlive(location, w), failure.getContinuation());
                    failure.jump(location, iterateAlive.getContinuation(), failure.apply(location, activeFact.nextFact, activeFact.factVar));
                    iterateUntilLiveFactFound(iterateAlive, activeFact);     
                }
            }
        }
        // PostCommit does not call nextOp
    }
    
    private void iterateUntilLiveFactFound(CodeWriter w, PartnerFact activeFact) {
        ICont initialContinuation = w.getContinuation();
        CHRConstraint constraint = activeFact.constraint;
        IVal fact = w.getParameters()[0];
        CodeWriter dead = w.createBlock();
        w.branchAwayIf(location, w.apply(location, NullCheck.INSTANCE.createSpecialization(constraint.factType), fact), activeFact.finishCont);
        w.branchAwayUnless(location, activeFact.isAlive(location, w, fact), dead.getContinuation());
        w.jump(location, activeFact.continueCont, fact);
        dead.jump(location, initialContinuation, dead.apply(location, activeFact.nextFact, fact));
    }

}
