package org.simantics.scl.compiler.elaboration.chr.plan;

import java.util.List;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.CHRRuleset;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class PlanRealizer extends PlanContext {
    List<PlanOp> ops;
    int id = 0;

    public PlanRealizer(CompilationContext context, CHRRuleset ruleset, IVal storeVar, IVal contextVar, List<PlanOp> ops) {
        super(context, ruleset, storeVar, contextVar);
        this.ops = ops;
    }

    @Override
    public void nextOp(CodeWriter w) {
        PlanOp planOp = ops.get(id);
        ++id;
        planOp.generateCode(context, this, w);
    }
    
}
