package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.constants.JavaComparisonOperation;
import org.simantics.scl.compiler.constants.JavaComparisonToZeroOperation;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.internal.codegen.continuations.ICont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class PartnerFact {
    public final boolean active;
    public final IVal id;
    public final CHRConstraint constraint;
    public final IVal factVar;
    public final boolean mayBeRemoved;
    public final boolean killAfterMatch;

    public final Constant nextFact;
    public final ICont continueCont;
    public final ICont finishCont;
    
    public PartnerFact(boolean active, IVal id, CHRConstraint constraint, IVal factVar, boolean mayBeRemoved, boolean killAfterMatch,
            Constant nextFact, ICont continueCont, ICont finishCont) {
        this.active = active;
        this.id = id;
        this.constraint = constraint;
        this.factVar = factVar;
        this.mayBeRemoved = mayBeRemoved;
        this.killAfterMatch = killAfterMatch;
        this.nextFact = nextFact;
        this.continueCont = continueCont;
        this.finishCont = finishCont;
    }
    
    public IVal isAlive(long location, CodeWriter w) {
        return w.apply(location, JavaComparisonOperation.IEQUAL, w.apply(location, constraint.accessId, factVar), id);
    }
    
    public IVal isAlive(long location, CodeWriter w, IVal fact) {
        return w.apply(location, JavaComparisonToZeroOperation.IGREATER_OR_EQUAL, w.apply(location, constraint.accessId, fact));
    }
}
