package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class ClaimOp extends PlanOp {

    CHRConstraint constraint;
    Expression[] parameters;

    public ClaimOp(long location, CHRConstraint constraint, Expression[] parameters) {
        super(location);
        this.constraint = constraint;
        this.parameters = parameters;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("CLAIM   ").append(constraint);
        for (Expression parameter : parameters)
            b.append(" (").append(parameter).append(')');
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        IVal[] parameterVars = new IVal[parameters.length+1];
        parameterVars[0] = planContext.generateNewId(location, w);
        for(int i=0;i<parameters.length;++i)
            parameterVars[i+1] = parameters[i].toVal(context, w);
        IVal newFact = w.apply(location, constraint.constructor, parameterVars);
        w.apply(location, constraint.addProcedure, planContext.getStoreVar(constraint), planContext.contextVar, newFact);
        planContext.nextOp(w);
    }

}
