package org.simantics.scl.compiler.elaboration.chr.plan;

import org.simantics.scl.compiler.compilation.CompilationContext;
import org.simantics.scl.compiler.constants.BooleanConstant;
import org.simantics.scl.compiler.elaboration.chr.relations.CHRConstraint;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.writer.CodeWriter;

public class AccessFactOp extends PlanOp {

    Expression inputFact;
    CHRConstraint constraint;
    Variable[] variables;
    boolean killAfterMatch;
    
    public AccessFactOp(long location, Expression inputFact, CHRConstraint constraint, Variable[] variables,
            boolean killAfterMatch) {
        super(location);
        this.inputFact = inputFact;
        this.constraint = constraint;
        this.variables = variables;
        this.killAfterMatch = killAfterMatch;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append("ACCESS  ");
        if(killAfterMatch)
            b.append("- ");
        b.append(constraint);
        for(Variable variable : variables)
            b.append(' ').append(variable);
        b.append(" = ").append(inputFact);
    }

    @Override
    public void generateCode(CompilationContext context, PlanContext planContext, CodeWriter w) {
        IVal inputVal = inputFact.toVal(context, w);
        for(int i=0;i<variables.length;++i)
            variables[i].setVal(constraint.accessComponent(location, w, inputVal, i));
        IVal activeId = w.apply(location, constraint.accessId, inputVal);
        CodeWriter end = constraint.mayBeRemoved() ? w.createBlock() : null;
        planContext.partnerFacts.add(new PartnerFact(true, activeId, constraint, inputVal, constraint.mayBeRemoved(), killAfterMatch, null, null, end == null ? null : end.getContinuation()));
        planContext.nextOp(w);
        if(end != null)
            end.return_(location, BooleanConstant.FALSE);
    }
}
