package org.simantics.scl.compiler.elaboration.chr.ast;

import java.util.ArrayList;
import java.util.List;

import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;

public class CHRAstConjunction extends CHRAstQuery {
    public List<CHRAstQuery> conjuncts;

    public CHRAstConjunction(List<CHRAstQuery> conjuncts) {
        this.conjuncts = conjuncts;
    }
    
    @Override
    public void accept(CHRAstQueryVisitor visitor) {
        visitor.visit(this);
    }
    
    public static CHRAstQuery conjunction(CHRAstQuery[] conjuncts) {
        ArrayList<CHRAstQuery> result = new ArrayList<CHRAstQuery>(conjuncts.length);
        for(CHRAstQuery conjunct : conjuncts) {
            if(conjunct instanceof CHRAstConjunction)
                result.addAll(((CHRAstConjunction)conjunct).conjuncts);
            else
                result.add(conjunct);
        }
        if(result.size() == 1)
            return result.get(0);
        else
            return new CHRAstConjunction(result);
    }

    @Override
    protected void translate(TranslationContext context, CHRQueryTranslationMode mode, ArrayList<CHRLiteral> literals) {
        for(CHRAstQuery conjunct : conjuncts)
            conjunct.translate(context, mode, literals);
    }
}
