package org.simantics.scl.compiler.elaboration.chr.ast;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.chr.CHRLiteral;
import org.simantics.scl.compiler.elaboration.chr.relations.SpecialCHRRelation;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;

public class CHRAstBinds extends CHRAstQuery {
    public Expression left;
    public Expression right;
    
    public CHRAstBinds(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }
    
    @Override
    public void accept(CHRAstQueryVisitor visitor) {
        visitor.visit(this);
    }
    
    @Override
    protected void translate(TranslationContext context, CHRQueryTranslationMode mode, ArrayList<CHRLiteral> literals) {
        literals.add(new CHRLiteral(location, SpecialCHRRelation.MEMBER,
                new Expression[] { left, right }, false, false));
    }
}
