package org.simantics.scl.compiler.constants.singletons;

import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;
import org.simantics.scl.runtime.tuple.Tuple0;

public class TypeProxyConstant extends Constant {
    
    private static final TVar A = Types.var(Kinds.STAR);
    public static final TypeProxyConstant INSTANCE = new TypeProxyConstant();
    
    private TypeProxyConstant() {
        super(Types.forAll(A, Types.apply(Types.TYPE_PROXY, A)));
    }

    @Override
    public void push(MethodBuilder mb) {
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter,
            Cont success, Label failure) {
        mb.jump(success);
    }
    
    public int constructorTag() {
        return 0;
    }
    
    @Override
    public String toString() {
        return "TypeProxy";
    }
    
    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return Tuple0.INSTANCE;
    }
}
