package org.simantics.scl.compiler.constants.singletons;

import org.objectweb.asm.Label;
import org.simantics.scl.compiler.constants.Constant;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class NothingConstant extends Constant {
    
    private static final TVar A = Types.var(Kinds.STAR);
    public static final NothingConstant INSTANCE = new NothingConstant();
    
    private NothingConstant() {
        super(Types.forAll(A, Types.apply(Types.MAYBE, A)));
    }

    @Override
    public void push(MethodBuilder mb) {
        mb.loadNull();
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter,
            Cont success, Label failure) {
        if(failure != null) {    
            parameter.push(mb);
            mb.ifNullBranch(failure, false);
        }
        mb.jump(success);
    }
    
    public int constructorTag() {
        return 0;
    }
    
    @Override
    public String toString() {
        return "Nothing";
    }
    
    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {                
        return null;
    }
}
